*==========================================================================*
* SAS programmer: James Nguyen, USEPA                                      *
*                                                                          *
* Project: OP inhibition studies                                           *
*                                                                          *
* Chemical: 16 OPs                                                         *
*                                                                          *
* Descriptions:                                                            *
*     - plot ki ratios from final models of human vs rat, adult vs infant, *
*       male vs female, and Caucasian vs non-Caucasian analyses            *
*                                                                          *
* Date: March 2020                                                         *
*=========================================================================*;
option formdlim="=" nodate nonumber ls=100 ps=100;


Proc import datafile="C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\Summarized results_v2.xlsx"
	dbms=xlsx replace out=KI_ratios;
	range="Est. Ratios$A1:J79";
	getnames=yes;
run;

Data KI_ratios;
	set KI_ratios;
	if chemical="" then delete;
run;

Data Ratio_HR;
	set KI_ratios(where=(comparison="human/rat"));
	if Comment in ("Exponent's selected model with a WARNING") then delete;
run;

ods rtf file ="C:\Users\JNguyen\Desktop\OP Inhibition\Plots of Ratios\Human-Rat Ratios.rtf";
title "Human/Rat ki Ratios";
proc sgplot data=Ratio_HR;
   scatter x=chemical y=est__ratio/yerrorupper=upper_95__CI yerrorlower=lower_95__CI;
   yaxis label="Est. Ratio (95% CI)";
   refline 1/axis=y;
run;
ods rtf close;



Data Ratio_AI;
	set KI_ratios(where=(comparison="adult/infant"));
	if Comment in ("Exponent's selected model with a WARNING", "This is Exponent model", "Exponent results") then delete;
run;

ods rtf file ="C:\Users\JNguyen\Desktop\OP Inhibition\Plots of Ratios\Adult-Infant Ratios.rtf";
title "Adult/Infant ki Ratios";
proc sgplot data=Ratio_AI;
   scatter x=chemical y=est__ratio/yerrorupper=upper_95__CI yerrorlower=lower_95__CI;
   yaxis label="Est. Ratio (95% CI)";
   refline 1/axis=y;
run;
ods rtf close;



Data Ratio_MF;
	set KI_ratios(where=(comparison="male/female"));
	if Comment in ("Exponent's selected model with a WARNING","Exponent results") then delete;
run;

ods rtf file ="C:\Users\JNguyen\Desktop\OP Inhibition\Plots of Ratios\Male-Female Ratios.rtf";
title "Male/Female ki Ratios";
proc sgplot data=Ratio_MF;
   scatter x=chemical y=est__ratio/yerrorupper=upper_95__CI yerrorlower=lower_95__CI;
   yaxis label="Est. Ratio (95% CI)";
   refline 1/axis=y;
run;
ods rtf close;




Data Ratio_CO;
	set KI_ratios(where=(comparison="Caucasian/other races"));
run;

ods rtf file ="C:\Users\JNguyen\Desktop\OP Inhibition\Plots of Ratios\Caucasian-other races Ratios.rtf";
title "Caucasian/Other-Races ki Ratios";
proc sgplot data=Ratio_CO;
   scatter x=chemical y=est__ratio/yerrorupper=upper_95__CI yerrorlower=lower_95__CI;
   yaxis label="Est. Ratio (95% CI)";
   refline 1/axis=y;
run;
ods rtf close;
